<?php
  session_start();
?>

<html>
<head>
<meta http-equiv="content-type" content="text/html" charset="utf-8">
<meta name="description" content="Datenbanken und SQL: Lesezugriff mit Comboboxen">
<meta name="author" content="Edwin Schicker">
<title>Datenbanken und SQL: Lesezugriff mit Comboboxen</title>
</head>

<body text="#000000" bgcolor="#FFFFEF" link="#FF0000" alink="#FF0000" vlink="#FF0000">
<center><h1>Datenbanken und SQL</h1></center>
<center><h3>Edwin Schicker</h3></center>
<p>Dies ist die Datei <i>auswahl.php</i> im Sessionteil, die Datei ruft sich selbst wieder auf. </p>

<?php
if (!isset($_SESSION['Hersteller']) and !isset($_SESSION['Parameter1']) and
    !isset($_SESSION['Kennung']) and !isset($_SESSION['Passwort']) )
{
  echo "<p>Bitte starten Sie zuerst mit der Eingabe-Startseite. Sie werden automatisch nach 5 Sekunden weitergeleitet.</p>";
  // automatisches Zurueckspringen nach 5 Sekunden nach 'index.html': 
  echo '<meta http-equiv="Refresh" content="5;url=index.html">';
}
else
{
  try
  {
     // neues PDO-Objekt anlegen und mit angegebenen DB verbinden:
     $conn = new PDO($_SESSION['Parameter1'],$_SESSION['Kennung'],$_SESSION['Passwort']);

     echo "<p>Die Verbindung zur Datenbank $_SESSION[Hersteller] wurde hergestellt.</p>";

     $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);   // ausfuehrliches Fehlerhandling
     $conn->setAttribute(PDO::ATTR_CASE, PDO::CASE_UPPER);             // immer Grossbuchstaben als Attributrueckgabe
     $conn->beginTransaction();                                        // Transaktionsmodus
     
     // Jetzt werden Artikel- und Kundendaten gelesen:
     $sql1 = "Select Anr, Bezeichnung                 
              From Artikel";                          // Artikeldaten
     $sql2 = "Select Nr, Name                         
              From Kunde" ;                           // Kundendaten

     $stmt1 = $conn->query($sql1);                    // Ausfuehren des 1. SQL-Befehls
     $stmt2 = $conn->query($sql2);                    // Ausfuehren des 2. SQL-Befehls

     // Ausgeben der gelesenen Daten:
     if (($row1 = $stmt1->fetch()) && ($row2 = $stmt2->fetch()))
     {     // Das Einlesen von je mindestens einem Wert hat geklappt
?>
       <p>Bitte wählen Sie einen Artikel und dazu einen oder mehrere Kunden aus. Durch Klick auf den
       Weiter-Button wird eine Liste generiert, die zu den angegebenen Kunden
       ausgibt, wann und wie oft diese genau diesen Artikel in Auftrag gegeben haben.</p>

     <!-- Tabelle mit 2 Select-Boxen: -->
       <form action="auswahl.php" method="post">
       <table cellpadding=10>
       <tr>
         <td align="right">Bitte wählen Sie einen Artikel aus: </td>
         <td><!-- Select Box: -->
           <select name="Artikelnr" size="1">      <!-- size="1": Drop Down Box -->
<?php
             // In einer Schleife werden die Daten fuer die Select Box ausgelesen:
             // Wurde schon einmal eine Auswahl getroffen, so wird diese letzte Auswahl 
             // mittels "selected" vorausgewaehlt
             do {
               echo "<option value=\"$row1[ANR]\"";
               if (isset($_POST['Artikelnr']) and $_POST['Artikelnr'] == $row1['ANR'])
                  echo " selected";
               echo "> $row1[BEZEICHNUNG]</option>";
             } while ($row1 = $stmt1->fetch());
?>
           </select>
         </td>
       </tr>
       <tr>
         <td align="right">Bitte wählen Sie einen oder mehrere Kunden aus: </td>
         <td><!-- Select Box: -->
           <select multiple name="Kundnr[]" size="5">      <!-- Select-Box -->
<?php
             // In einer Schleife werden die Daten fuer die Select Box ausgelesen:
             //  siehe auch erste Select-Box wegen Vorauswahl
             do {
               echo "<option value=\"$row2[NR]\"";
               if (isset($_POST['Kundnr']) and in_array($row2['NR'], $_POST['Kundnr']))   
                 echo " selected";       // dieser Kunde ist ein zuletzt markierter Kunde
               echo "> $row2[NAME]</option>";
             } while ($row2 = $stmt2->fetch());
?>
           </select>
         </td>
       </tr>
       <tr>
         <td></td>
         <td> <input type="Submit" value="Weiter"/> </td>
       </tr>
     </table>
     </form>
<?php
    } else          // eigene Ausnahme werfen:
         throw new PDOException ("Kunden-/Artikeldaten konnten nicht gelesen werden", 13);

    if (isset($_POST['Kundnr']) and isset($_POST['Artikelnr'])) {
      echo "<hr noshade size=\"1\">";
      echo "<p>Die gewünschten Daten werden jetzt in der Datenbank gesucht.</p><p>";

      // Lesen der Post-Variablen:
      $Kundfeldnr = $_POST['Kundnr'];           // liefert ein Array!
      $Artikelnr  = $_POST['Artikelnr'];

      if (count($Kundfeldnr) > 0)              // wurde auch mindestens ein Kunde ausgewaehlt?
      {
        // Die Datenbank ist geoeffnet, jetzt werden die Daten gelesen:
        $sql = "Select A.Auftrnr As Auftrag, Kundnr, Datum, Persnr, Anzahl, Gesamtpreis
                From   Auftrag A Inner Join Auftragsposten AP On A.Auftrnr = AP.Auftrnr
                Where  Kundnr In (" . implode(",", $Kundfeldnr) . ")
                  And  Artnr = $Artikelnr ";

        $stmt = $conn->query($sql);                  // Ausfuehren des 3. SQL-Befehls

        // Ausgeben der gelesenen Daten:
        if (!($row = $stmt->fetch())) {        // Keine Daten
          echo "<p>Die markierten Kunden haben den Artikel $Artikelnr bisher nicht in Auftrag gegeben.</p>";
        } else {
          echo "<p>Die markierten Kunden haben den Artikel $Artikelnr insgesamt wie folgt in Auftrag gegeben:</p>";
?>
          <!-- Kopfzeile einer Tabelle definieren (mit <th> statt <td>: -->
          <p>
          <table border cellpadding=10>
           <tr>
            <th>Auftragsnr </th>
            <th>Kundennr </th>
            <th>Auftragsdatum </th>
            <th>Verkäufernr </th>
            <th>Anzahl </th>
            <th>Gesamtpreis </th>
           </tr>
<?php
          // In einer Schleife werden die Daten ausgelesen:
          do {
            echo "<tr>";
            // Die ausgelesenen Daten werden gleich in die Tabelle uebernommen:
            echo "<td> $row[AUFTRAG] </td>",
                  "<td> $row[KUNDNR]</td>",
                  "<td> $row[DATUM]</td>",
                  "<td> $row[PERSNR]</td>",
                  "<td> $row[ANZAHL]</td>",
                  "<td> $row[GESAMTPREIS]</td>",
                 "</tr>";
          } while ($row = $stmt->fetch());
  
          echo "</table>";
        }
      }
      else 
        echo "<p>Es wurde kein Kunde ausgewählt!</p>";

      // Die Datenbank wird jetzt geschlossen:
      $conn->commit();
      $stmt = null; $stmt1 = null; $stmt2 = null; $conn = null;    // Beenden der Verbindung
      echo "<p>Die Verbindung zur Datenbank wird geschlossen.</p>";
    }
  }
   // PDO Fehlerbehandlung
  catch (PDOException $e)
  {
     echo "<p>Datenbankfehler in Zeile ", $e->getLine(), " mit Fehlercode ", $e->getCode(), " (", $e->errorInfo[1], ")</p>",
          "<p>Fehlertext: ", $e->getMessage(), "</p>";  
  }   
 
   // Globale Fehlerbehandlung
  catch (Exception $e)
  {
     echo "<p>Fehler in Zeile ", $e->getLine(), " mit Fehlercode ", $e->getCode(), "</p>",
          "<p>Fehlertext: ", $e->getMessage(), "</p>";  
  }   
}
?>
<hr noshade size="1">
<p><center><a href="index.php">Zurück zur Auswahlseite der Session</a></center></p>
<p><center><a href="reset.php">Beenden der Session und neues Einloggen</a></center></p>
</body>
</html>