<?php
  session_start();
?>

<html>
<head>
<meta http-equiv="content-type" content="text/html" charset="utf-8">
<meta name="description" content="Datenbanken und SQL: BLOB einlesen 3">
<meta name="author" content="Edwin Schicker">
<title>Datenbanken und SQL: BLOB einlesen 3</title>
</head>

<body text="#000000" bgcolor="#FFFFEF" link="#FF0000" alink="#FF0000" vlink="#FF0000">
<center><h1>Datenbanken und SQL</h1></center>
<center><h3>Edwin Schicker</h3></center>
<p>Dies ist die Datei <i>blob_ein3.php</i> im Sessionteil, die ein Bild in die Datenbank speichert. </p>

<?php
if (!isset($_SESSION['Hersteller']) and !isset($_SESSION['Parameter1']) and
    !isset($_SESSION['Kennung']) and !isset($_SESSION['Passwort']) )
{
  echo "<p>Bitte starten Sie zuerst mit der Eingabe-Startseite. Sie werden automatisch nach 5 Sekunden weitergeleitet.</p>";
  // automatisches Zurueckspringen nach 5 Sekunden nach 'index.html': 
  echo '<meta http-equiv="Refresh" content="5;url=index.html">';
}
else
{
  if (isset($_SESSION['Bild']) && isset($_POST['Persnr']) && is_numeric($_POST['Persnr'])) {
     // Uebergabevariablen muessen existieren und die Persnr muss eine Zahl sein!
  try
  {
    // neues PDO-Objekt anlegen und mit angegebenen DB verbinden:
   $conn = new PDO($_SESSION['Parameter1'],$_SESSION['Kennung'],$_SESSION['Passwort']);

   echo "<p>Die Verbindung zur Datenbank $_SESSION[Hersteller] wurde hergestellt.</p>";

   $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);   // ausfuehrliches Fehlerhandling
   $conn->setAttribute(PDO::ATTR_CASE, PDO::CASE_UPPER);             // immer Grossbuchstaben als Attributrueckgabe
   $conn->beginTransaction();                                        // Transaktionsmodus

   // Herstellerspezifischen Befehl aufbauen:
   switch ($_SESSION['Hersteller'])
   {
      case 'Oracle': 
      case 'OracleUTF8':$sql1 = "EMPTY_BLOB()";
                        $sql2 = "Returning Bild into :bild";
                        break;
      case 'MySQL':     $sql1 = ":bild";
                        $sql2 = "";
                        break;
      case 'SQLServer': $sql1 = "CONVERT(varbinary(max), :bild)";
                        $sql2 = "";
   }      
   $sql = "Update Personal Set Bildtyp = :typ, Bild = $sql1
                           Where Persnr = $_POST[Persnr]  
                           $sql2" ; 
                     
    // Ausfuehrung wird vorbereitet, zwei variable Werte werden verwendet:
   $stmt = $conn->prepare($sql);
   
    // Die Datei wird zum Lesen binaer geoeffnet:
   $fp = fopen($_SESSION['Bild'], 'rb');

    // Die Fragezeichen werden jetzt mit Werten besetzt:
   $stmt->bindParam(':typ', $_SESSION['Bildtyp'], PDO::PARAM_STR);
   if ($_SESSION['Hersteller'] == 'SQLServer')
      $stmt->bindParam(':bild', $fp, PDO::PARAM_LOB, 0, PDO::SQLSRV_ENCODING_BINARY);
   else
      $stmt->bindParam(':bild', $fp, PDO::PARAM_LOB);

   $stmt->execute();

   fclose($fp);            // schliessen
   $conn->commit();

   // ueberpruefen, ob ueberhaupt Zeilen geaendert wurden:
   if ($stmt->rowCount() == 0)
      echo "<p>Es wurde kein Update durchgeführt. War Persnr korrekt?</p>";
   else   
      echo "<p>Abspeichern des Bildes wurde erfolgreich durchgeführt. Die Verbindung zur Datenbank wurde geschlossen.</p>";
   $stmt = null; $conn = null;          // Beenden der Verbindung
  }  // end try
 
   // PDO Fehlerbehandlung
  catch (PDOException $e)
  {
     echo "<p>Datenbankfehler in Zeile ", $e->getLine(), " mit Fehlercode ", $e->getCode(), " (", $e->errorInfo[1], ")</p>",
          "<p>Fehlertext: ", $e->getMessage(), "</p>";  
  }   
 
   // Globale Fehlerbehandlung
  catch (Exception $e)
  {
     echo "<p>Fehler in Zeile ", $e->getLine(), " mit Fehlercode ", $e->getCode(), "</p>",
          "<p>Fehlertext: ", $e->getMessage(), "</p>";  
  }   
  }  // endif 
?>
  <hr noshade size="1">
  <p><center><a href="blob_ein1.php">Zurück zur Bildauswahlseite</a></center></p>
  <p><center><a href="index.php">Zurück zur Auswahlseite der Session</a></center></p>
  <p><center><a href="reset.php">Beenden der Session und neues Einloggen</a></center></p>
<?php
}  // endif  
?>

</body>
</html>