<?php
   session_start();
?>
<html>
<head>
<meta http-equiv="content-type" content="text/html" charset="utf-8">
<meta name="description" content="Datenbanken und SQL: Überblick, Session">
<meta name="author" content="Edwin Schicker">
<title>Datenbanken und SQL: Sessioneinsprungseite, Teil 2</title>
</head>

<body text="#000000" bgcolor="#FFFFEF" link="#FF0000" alink="#FF0000" vlink="#FF0000">
<center><h1>Datenbanken und SQL</h1></center>
<center><h3>Edwin Schicker</h3></center>
<p>Dies ist die Datei <i>index.php</i> im Sessionteil. Von hier aus wird zu den einzelnen Themen verzweigt. </p>

<?php
// Ueberpruefen, ob die notwendigen Einlogdaten exisitieren, entweder als Post- oder als Sessionvariable:
if ( (!isset($_POST['Hersteller']) and !isset($_SESSION['Hersteller'])) or 
     ((!isset($_POST['Datenbank']) or !isset($_POST['Server'])) and !isset($_SESSION['Parameter1'])) or 
     (!isset($_POST['Kennung']) and !isset($_SESSION['Kennung'])) or 
     (!isset($_POST['Passwort']) and !isset($_SESSION['Passwort'])) )
   echo "<p>Bitte loggen Sie sich erst in die Datenbank ein</p>";
else
{
   if (!isset($_SESSION['Hersteller']))       // Session-Variablen noch nicht gesetzt!
   {
      // Sessionvariablen aus Postvariablen uebernehmen:
      $_SESSION['Hersteller'] = $_POST['Hersteller'];
      $_SESSION['Kennung']    = $_POST['Kennung'];
      $_SESSION['Passwort']   = $_POST['Passwort'];
      
      // Neue Sessionvariable Parameter1 aus Datenbank und Server erzeugen:
      switch ($_SESSION['Hersteller'])    // Einloggen in die Datenbank je nach Hersteller
      {
        case "Oracle":     $_SESSION['Parameter1'] = "oci:dbname=$_POST[Datenbank]";         
                           break;
        case "OracleUTF8": $_SESSION['Parameter1'] = "oci:dbname=$_POST[Datenbank];charset=utf8";         
                           break;
        case "SQLServer":  $_SESSION['Parameter1'] = "sqlsrv:Server=$_POST[Server];Database=$_POST[Datenbank]";  
                           break;
        case "MySQL":      $_SESSION['Parameter1'] = "mysql:host=$_POST[Server];dbname=$_POST[Datenbank]";
                           break;
      }
   }

?>
   <p>Bitte wählen Sie eines der folgenden Themen aus. Die Realisierung ist 
     bewusst einfach gehalten. Klicken Sie den gewünschten Button:</p>

   <table cellpadding="10">
   <tr>
    <td align="right"> <form action="start.php">
                       <input type="Submit" value="Erster DB-Zugriff auf die Bike-DB">
                      </form>
    </td>
    <td valign="top"> Die Datei <i>start.php</i> wird aufgerufen
    </td>
   </tr>
   <tr>
    <td align="right"> <form action="mitarbeiter.php">
                       <input type="Submit" value="Ausgabe der Relation Personal"/>
                      </form>
    </td>
    <td valign="top"> Die Datei <i>mitarbeiter.php</i> wird aufgerufen
    </td>
   </tr>
   <tr>
    <td align="right"> <form action="auswahl.php">
                       <input type="Submit" value="DB-Zugriff mit Select-Auswahl"/>
                      </form>
    </td>
    <td valign="top"> Die Datei <i>auswahl.php</i> wird aufgerufen </td>
   </tr>
   <tr>
    <td align="right"> <form action="select.php">
                       <input type="Submit" value="Beliebigen SQL-Befehl ausführen"/>
                     </form>
    </td>
    <td valign="top"> Die Datei <i>select.php</i> wird aufgerufen
    </td>
   </tr>
   <tr>
    <td align="right"> <form action="select2.php">
                       <input type="Submit" value="Beliebigen SQL-Befehl ausführen, mit Funktion"/>
                     </form>
    </td>
    <td valign="top"> Die Datei <i>select2.php</i> wird aufgerufen
    </td>
   </tr>
   <tr>
    <td align="right"> <form action="injection1.php">
                       <input type="Submit" value="SQL-Injection verhindern: Teil 1"/>
                     </form>
    </td>
    <td valign="top"> Die Datei <i>injection1.php</i> wird aufgerufen
    </td>
   </tr>
   <tr>
    <td align="right"> <form action="injection2.php">
                       <input type="Submit" value="SQL-Injection verhindern: Teil 2"/>
                     </form>
    </td>
    <td valign="top"> Die Datei <i>injection2.php</i> wird aufgerufen
    </td>
   </tr>
   <tr>
    <td align="right"> <form action="injection3.php">
                       <input type="Submit" value="SQL-Injection verhindern: Teil 3"/>
                     </form>
    </td>
    <td valign="top"> Die Datei <i>injection3.php</i> wird aufgerufen
    </td>
   </tr>
   <tr>
    <td align="right"> <form action="transaktion1.php">
                       <input type="Submit" value="Schreib-Transaktion ausführen"/>
                     </form>
    </td>
    <td valign="top"> Die Datei <i>transaktion1.php</i> wird aufgerufen
    </td>
   </tr>
   <tr>
    <td align="right"> <form action="blob_ein1.php">
                       <input type="Submit" value="Bild in DB speichern"/>
                     </form>
    </td>
    <td valign="top"> Die Datei <i>blob_ein1.php</i> wird aufgerufen
    </td>
   </tr>
   <tr>
    <td align="right"> <form action="mitarbeiterblob.php">
                       <input type="Submit" value="Bilder aus DB auslesen"/>
                     </form>
    </td>
    <td valign="top"> Die Datei <i>mitarbeiterblob.php</i> wird aufgerufen
    </td>
   </tr>
   <tr>
    <td align="right"> <form action="reset.php">
                       <input type="Submit" value="Session zurücksetzen"/>
                     </form>
    </td>
    <td valign="top"> Die Datei <i>reset.php</i> wird aufgerufen </td>
   </tr>
   </table>

<?php
}  //endif
?>

<p><b>Hier können die Übungsaufgaben aus Kapitel 6 eingefügt werden:</b></p>
<p>
  <a href="ueb_kap6_3.php">Übung 3 (ueb_kap6_3.php)</a> <br/>
  <a href="ueb_kap6_4.php">Übung 4 (ueb_kap6_4.php)</a> <br/>
  <a href="ueb_kap6_5.php">Übung 5 (ueb_kap6_5.php)</a> <br/>
  <a href="ueb_kap6_6.php">Übung 6 (ueb_kap6_6.php)</a> <br/>
  <a href="ueb_kap6_7.php">Übung 7 (ueb_kap6_7.php)</a> <br/>
  <a href="ueb_kap6_8.php">Übung 8 (ueb_kap6_8.php)</a> <br/>
  <a href="ueb_kap6_9.php">Übung 9 (ueb_kap6_9.php)</a> <br/></p>

<hr noshade size="1">
<p><center><a href="reset.php">Beenden der Session und neues Einloggen</a></center></p>
</body>
</html>