<?php
  session_start();
?>

<html>
<head>
<meta http-equiv="content-type" content="text/html" charset="utf-8">
<meta name="description" content="Datenbanken und SQL: Einfache GUI">
<meta name="author" content="Edwin Schicker">
<title>Datenbanken und SQL: SQL Injection - Teil 1</title>
</head>

<body text="#000000" bgcolor="#FFFFEF" link="#FF0000" alink="#FF0000" vlink="#FF0000">
<center><h1>Datenbanken und SQL</h1></center>
<center><h3>Edwin Schicker</h3></center>
<p>Dies ist die Datei <i>injection1.php</i> im Sessionteil; die Datei ruft sich selbst wieder auf. </p>

<?php
if (!isset($_SESSION['Hersteller']) and !isset($_SESSION['Parameter1']) and
    !isset($_SESSION['Kennung']) and !isset($_SESSION['Passwort']) )
{
  echo "<p>Bitte starten Sie zuerst mit der Eingabe-Startseite. Sie werden automatisch nach 5 Sekunden weitergeleitet.</p>";
  // automatisches Zurueckspringen nach 5 Sekunden nach 'index.html': 
  echo '<meta http-equiv="Refresh" content="5;url=index.html">';
}
else
{
?>
  <p>Geben Sie einen SQL-Befehl ein.</p>
  <p>Achtung: Jeder Einzelbefehl wird <b>committed</b>!</p>
  <p>Im ungeschützten Modus kann Schadsoftware eingeschleust werden. Testen Sie dies durch die folgende Eingabe:
  <i>&lt;/textarea&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;br/&gt;Hier könnte Schadsoftware stehen. </i></p>
  <p>Im geschützten Modus stört diese Eingabe nicht!</p>

  <form action="injection1.php" method="post">
    <table cellpadding=10>
       <tr>
        <td valign="top">SQL-Befehl<br/>(ohne Semikolon!): </td>
<?php
       if (isset($_POST['schutz']) and $_POST['schutz'] == 'mit')           // mit Schutz durch htmlspecialchars
       {
?>
        <td><textarea name="Eingabe" rows="10" cols="60" wrap="virtual"><?php
                     echo isset($_POST['Eingabe'])?trim(htmlspecialchars($_POST['Eingabe'])): ""; ?>
            </textarea></td>
<?php
       }
       else                                                                  // ohne Schutz durch htmlspecialchars
       {       
?>
        <td><textarea name="Eingabe" rows="10" cols="60" wrap="virtual"><?php
                     echo isset($_POST['Eingabe'])?trim($_POST['Eingabe']): ""; ?>
            </textarea></td>
<?php
       }
?>
       </tr>
       <tr>
        <td>Ungeschützt:</td>
        <td><input type="radio" name="schutz" value="ohne" checked/></td>
       </tr>
       <tr>
        <td>Geschützt:</td>
        <td><input type="radio" name="schutz" value="mit"/></td>
       </tr>
       <tr>
        <td></td><td><input type="Submit" value="Ausführen"/></td>
       </tr>
    </table>
  </form>
  
<?php
  if (isset($_POST['Eingabe'])) 
  try
  {
    // neues PDO-Objekt anlegen und mit angegebenen DB verbinden:
   $conn = new PDO($_SESSION['Parameter1'],$_SESSION['Kennung'],$_SESSION['Passwort']);

   echo "<hr noshade size=\"1\">";
   echo "<p>Die Verbindung zur Datenbank $_SESSION[Hersteller] wurde hergestellt.</p>";

   $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);   // ausfuehrliches Fehlerhandling
   $conn->setAttribute(PDO::ATTR_CASE, PDO::CASE_UPPER);             // immer Grossbuchstaben als Attributrueckgabe
   $conn->beginTransaction();                                        // Transaktionsmodus

    // Ueberpruefen, um welchen Befehl es sich handelt.
   $Eingabe = trim($_POST['Eingabe']);                               // Fuehrende Leerzeichen entfernen
   $stmt = $conn->query($Eingabe);                                   // Ausfuehren des SQL-Befehls

   $erstesWort = substr($Eingabe, 0, 6);      // Erstes Wort: Select, Delete, Update, Insert sind 6 Zeichen lang

   if (strCaseCmp($erstesWort,"SELECT")==0)
   {                                           // Select Befehl
     // erste Zeile lesen:
     if ( $row = $stmt->fetch(PDO::FETCH_ASSOC) )         // nur assoziative Felder wegen foreach ausgeben!
     {
       echo "<table border=\"2\" cellpadding=\"2\"><tr>";
       foreach ( $row as $colname => $data )         // bitte Syntax fuer assoziative Felder beachten!
       {
         echo "<th> $colname </th>";    // Spaltennamen ausgeben
       }
       echo "</tr>";
       do
       {
         echo "<tr>";
         foreach ( $row as $data )
           echo "<td>" . ($data == null ? "(null)" : $data) . "</td>";      // Daten ausgeben
           echo "</tr>";                     // Zeile beenden
       }
       while ( $row = $stmt->fetch(PDO::FETCH_ASSOC) );
       echo "</table>";
     }	
     else
       echo "<p>Keine Daten</p>";	   
   }
   elseif (strCaseCmp($erstesWort,"INSERT")==0)
   {
     echo "<p>", $stmt->rowCount(), " Zeile(n) wurde(n) eingefügt.</p>";
   }
   elseif (strCaseCmp($erstesWort,"UPDATE")==0)
   {
     echo "<p>", $stmt->rowCount(), " Zeile(n) wurde(n) geändert.</p>";
   }
   elseif (strCaseCmp($erstesWort,"DELETE")==0)
   { 
     echo "<p>", $stmt->rowCount(), " Zeile(n) wurde(n) gelöscht.</p>";
   }
   else
   {
     echo "<p>Ein DDL-Befehl wurde ausgeführt.</p>";
   }

   $conn->commit();
   echo "<p>Transaktion erfolgreich abgeschlossen. Die Verbindung zur Datenbank wird geschlossen.</p>";
   $stmt = null; $conn = null;
  }  // end try
 
   // PDO Fehlerbehandlung
  catch (PDOException $e)
  {
     echo "<p>Datenbankfehler in Zeile ", $e->getLine(), " mit Fehlercode ", $e->getCode(), " (", $e->errorInfo[1], ")</p>",
          "<p>Fehlertext: ", $e->getMessage(), "</p>";  
  }   
 
   // Globale Fehlerbehandlung
  catch (Exception $e)
  {
     echo "<p>Fehler in Zeile ", $e->getLine(), " mit Fehlercode ", $e->getCode(), "</p>",
          "<p>Fehlertext: ", $e->getMessage(), "</p>";  
  }   
}  // endif  
?>
<hr noshade size="1">
<p><center><a href="index.php">Zurück zur Auswahlseite der Session</a></center></p>
<p><center><a href="reset.php">Beenden der Session und neues Einloggen</a></center></p>
</body>
</html>