<?php
  session_start();
?>

<html>
<head>
<meta http-equiv="content-type" content="text/html" charset="utf-8">
<meta name="description" content="Datenbanken und SQL: Auslesen mehrerer Zeilen in Session">
<meta name="author" content="Edwin Schicker">
<title>Datenbanken und SQL: SQL-Injection - Teil 3</title>
</head>

<body text="#000000" bgcolor="#FFFFEF" link="#FF0000" alink="#FF0000" vlink="#FF0000">
<center><h1>Datenbanken und SQL</h1></center>
<center><h3>Edwin Schicker</h3></center>
<p>Dies ist die Datei <i>injection3.php</i> im Sessionteil. </p>

<?php
if (!isset($_SESSION['Hersteller']) and !isset($_SESSION['Parameter1']) and
    !isset($_SESSION['Kennung']) and !isset($_SESSION['Passwort']) )
{
  echo "<p>Bitte starten Sie zuerst mit der Eingabe-Startseite. Sie werden automatisch nach 5 Sekunden weitergeleitet.</p>";
  // automatisches Zurueckspringen nach 5 Sekunden nach 'index.html': 
  echo '<meta http-equiv="Refresh" content="5;url=index.html">';
}
else
{
?>

  <p>Diese Seite zeigt die Anfälligkeit von SQL-Zugriffen auf: Fahrlässige 
  Programmierung hebelt den Passwortschutz aus.</p>
  <p>Name und Passwort werden in die Variablen ($kenn, $pass) eingelesen.</p> 
  <p>Das Passwort wird in der Variable $passwort gespeichert und heißt hier einfachheitshalber <i>Freitag13</i>.</p>
  <p>Der hier verwendete Code ist in der Praxis enorm gefährlich:</p>
  <p>---><i>Select * From Personal Where Name = '$kenn' And $passwort = '$pass'</i></p>
  <p>---> Die Eingabe >> <i>Maria Forster' --</i> << ignoriert das Passwort! Die Eingabe >> <i>' Or 1=1 --</i> << ignoriert Name und Passwort!</p>
  <br/>
  <p>Bitte testen! Wenn Sie auf <i>geschützt</i> klicken, wird mit <i>prepare</i>, <i>bindParam</i> und <i>execute</i> gearbeitet. 
     Dann sind wir geschützt. Ohne korrekte Eingaben geht nichts mehr!</p>

  <form action="injection3.php" method="post">
  <table cellpadding="10">
  <tr>
   <td align="right">Bitte geben Sie einen Mitarbeiternamen (mit Vornamen) ein:</td>
   <td> <!-- Eingabefeld: -->
        <input type="Text" name="Kennung" size="30" maxlength="30" 
                value="<?php echo isset($_POST['Kennung'])?"$_POST[Kennung]":"";?>"></td>
  </tr>
  <tr>
   <td align="right">Bitte geben Sie das Passwort ein (zu Testzwecken sichtbar):</td>
   <td> <!-- Eingabefeld: -->
        <input type="Text" name="Passwort" size="30" maxlength="30" 
                value="<?php echo isset($_POST['Passwort'])?"$_POST[Passwort]":"";?>"></td>
  </tr>
  <tr>
   <td align="right">Ungeschützt:</td>
   <td> <input type="radio" name="schutz" value="ohne" checked/>
  </tr>
  <tr>
   <td align="right">Geschützt:</td>
   <td> <input type="radio" name="schutz" value="mit"/>
  </tr>
  <tr>
   <td></td>
   <td align="right"> <input type="Submit" value="Weiter"/>
   </td>
  </tr>
  </table>
  </form>
  <hr noshade size="1">

<?php
   // Der folgende Code wird nur ausgefuehrt, wenn die Post-Variable
   // Name bereits einmal uebergeben wurde!

  if (isset($_POST['Kennung']) and isset($_POST['Passwort'])) {
    $kenn = trim($_POST['Kennung']);    // ev. Leerzeichen entfernen
    $pass = $_POST['Passwort'];
    try
    {
      // neues PDO-Objekt anlegen und mit angegebenen DB verbinden:
      $conn = new PDO($_SESSION['Parameter1'],$_SESSION['Kennung'],$_SESSION['Passwort']);

      echo "<p>Die Verbindung zur Datenbank $_SESSION[Hersteller] wurde hergestellt. </p>";

      $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);   // ausfuehrliches Fehlerhandling
      $conn->setAttribute(PDO::ATTR_CASE, PDO::CASE_UPPER);             // immer Grossbuchstaben als Attributrueckgabe
      $conn->beginTransaction();                                        // Transaktionsmodus

      echo "Der eingegebene Name wird mit den Mitarbeiternamen verglichen, ebenso das Passwort mit 'Freitag13'";
      $passwort = 'Freitag13';
      
      // Die Datenbank ist geoeffnet, jetzt wird zugegriffen:
      $sql1 = "Select *
               From Personal
               Where Trim(Name) = '$kenn' And '$passwort' = '$pass'";
      $sql2 = "Select *
               From Personal
               Where Trim(Name) = :kenn And '$passwort' = :pass";

      if ($_POST['schutz'] == 'ohne')
      {
         echo "<p>Ungeschützt: $sql1</p>";
         $stmt = $conn->query($sql1);                          // Ausfuehren des Befehls und Ablage in $stmt
      }
      else
      {
         echo "<p>Geschützt: $sql2</p>";
         $stmt = $conn->prepare($sql2);                // Der Aufbau des SQL-Befehls ist unabhängig von der Eingabe vorgegeben
         $stmt->bindParam(':kenn', $kenn, PDO::PARAM_STR);
         $stmt->bindParam(':pass', $pass, PDO::PARAM_STR);
         $stmt->execute();
      }
 
      // Ausgeben der gelesenen Daten:
      if (!($row = $stmt->fetch())) {
         echo "Entweder der Mitarbeiter oder das Passwort sind nicht korrekt! Das Einloggen wird abgewiesen.";
      } else {
         echo "Glückwunsch! Das Einloggen war erfolgreich! Wenn Sie geschummelt haben, sehen Sie, wie gefährlich das ist.";
      }  // endif fetch

      // Die Datenbank wird jetzt geschlossen:
      $conn->commit();
      $stmt = null; $conn = null;      // Beenden der Verbindung
    }  // endif try
   
     // PDO Fehlerbehandlung
    catch (PDOException $e)
    {
      echo "<p>Datenbankfehler in Zeile ", $e->getLine(), " mit Fehlercode ", $e->getCode(), " (", $e->errorInfo[1], ")</p>",
           "<p>Fehlertext: ", $e->getMessage(), "</p>";  
    }   
 
  // Globale Fehlerbehandlung
  catch (Exception $e)
  {
     echo "<p>Fehler in Zeile ", $e->getLine(), " mit Fehlercode ", $e->getCode(), "</p>",
          "<p>Fehlertext: ", $e->getMessage(), "</p>";  
  }   
}  // endif isset
}
?>

<p><center><a href="index.php">Zurück zur Auswahlseite der Session</a></center></p>
<p><center><a href="reset.php">Beenden der Session und neues Einloggen</a></center></p>
</body>
</html>