<?php
function tabelle($stmt)
{
 try
 {
    // erste Zeile lesen:
    if ( $row = $stmt->fetch(PDO::FETCH_ASSOC) )         // nur assoziative Felder wegen foreach ausgeben!
    {
       echo "<table border=\"2\" cellpadding=\"2\"><tr>";
       foreach ( $row as $colname => $data )            // bitte Syntax fuer assoziative Felder beachten!
       {
          echo "<th> $colname </th>";    // Spaltennamen ausgeben
       }
       echo "</tr>";
       do
       {
          echo "<tr>";
          foreach ( $row as $data )
             echo "<td>" . ($data == null ? "(null)" : $data) . "</td>";      // Daten ausgeben
             echo "</tr>";                     // Zeile beenden
       }
       while ( $row = $stmt->fetch(PDO::FETCH_ASSOC) );
       echo "</table>";
       return true;              // Tabelle wurde ausgegeben
    }
    else
       return false;          // keine Daten
 }  // end try
 
   // PDO Fehlerbehandlung
 catch (PDOException $e)
 {
    echo "<p>Datenbankfehler in Zeile ", $e->getLine(), " mit Fehlercode ", $e->getCode(), " (", $e->errorInfo[1], ")</p>",
          "<p>Fehlertext: ", $e->getMessage(), "</p>"; 
    return false;   
 }   
 
   // Globale Fehlerbehandlung
 catch (Exception $e)
 {
    echo "<p>Fehler in Zeile ", $e->getLine(), " mit Fehlercode ", $e->getCode(), "</p>",
          "<p>Fehlertext: ", $e->getMessage(), "</p>";  
    return false;
 }   
 
}  // end function  
?>
