<?php
  session_start();
?>

<html>
<head>
<meta http-equiv="content-type" content="text/html" charset="utf-8">
<meta name="description" content="Datenbanken und SQL: Mitarbeiter mit Bild auslesen">
<meta name="author" content="Edwin Schicker">
<title>Datenbanken und SQL: Mitarbeiter mit Bild auslesen</title>
</head>

<body text="#000000" bgcolor="#FFFFEF" link="#FF0000" alink="#FF0000" vlink="#FF0000">
<center><h1>Datenbanken und SQL</h1></center>
<center><h3>Edwin Schicker</h3></center>
<p>Dies ist die Datei <i>mitarbeiterblob.php</i> im Sessionteil, die intern die Datei <i>bild.php</i> aufruft. </p>

<?php
if (!isset($_SESSION['Hersteller']) and !isset($_SESSION['Parameter1']) and
    !isset($_SESSION['Kennung']) and !isset($_SESSION['Passwort']) )
{
  echo "<p>Bitte starten Sie zuerst mit der Eingabe-Startseite. Sie werden automatisch nach 5 Sekunden weitergeleitet.</p>";
  // automatisches Zurueckspringen nach 5 Sekunden nach 'index.html': 
  echo '<meta http-equiv="Refresh" content="5;url=index.html">';
}
else
{
?>

  <p>Mit Hilfe dieser Seite wird auf die Datenbank BIKE lesend zugreifen. Geben Sie
  dazu im Eingabefeld eine Zeichenkette ein. Jeder Mitarbeiter, der diese Zeichenkette im 
  Namen enthält, wird ausgegeben. Neben dem Namen wird auch Wohnort, Geburtsdatum, Gehalt
  und insbesondere das Bild mit ausgegeben.</p>
  <p>Bitte geben Sie den gesuchten Teilnamen ein, und klicken Sie dann den Weiter-Button.</p>

  <form action="mitarbeiterblob.php" method="post">
  <table cellpadding="10">
  <tr>
   <td align="right">Bitte geben Sie die Suchzeichen ein:</td>
   <td> <!-- Eingabefeld: -->
        <input type="Text" name="Suchstring" size="30" maxlength="30" 
                value=<?php echo isset($_POST['Suchstring'])?$_POST['Suchstring']:""; ?>></td>
  </tr>
  <tr>
   <td></td>
   <td align="right"> <input type="Submit" value="Weiter"/>
   </td>
  </tr>
  </table>
  </form>
  <hr noshade size="1">

<?php
   // Der folgende Code wird nur ausgefuehrt, wenn die Post-Variable
   // Name bereits einmal uebergeben wurde!

  if (isset($_POST['Suchstring'])) {
    $suche = trim($_POST['Suchstring']);    // ev. Leerzeichen entfernen
    if (strlen($suche) == 0) {
      echo "Es wurde im Formular kein Suchbegriff eingegeben.";
    } else {
     try
     {
       // neues PDO-Objekt anlegen und mit angegebenen DB verbinden:
       $conn = new PDO($_SESSION['Parameter1'],$_SESSION['Kennung'],$_SESSION['Passwort']);

       echo "<p>Die Verbindung zur Datenbank $_SESSION[Hersteller] wurde hergestellt.</p>";
     

       $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);   // ausfuehrliches Fehlerhandling
       $conn->setAttribute(PDO::ATTR_CASE, PDO::CASE_UPPER);             // immer Grossbuchstaben als Attributrueckgabe
       $conn->beginTransaction();                                        // Transaktionsmodus

       echo "Die Datenbank BIKE wird jetzt nach allen Mitarbeitern ",
             "durchsucht, die im Namen den Teilstring >$suche< enthalten.<br>";

       // Die Datenbank ist geoeffnet, jetzt wird zugegriffen, wieder gibt es datenbankspezifische Einstellungen:
       switch ( $_SESSION['Hersteller'] )
       {
          case 'Oracle':
          case 'OracleUTF8':$laenge = 'Dbms_Lob.Getlength(Bild)';
                            break;
          case 'MySQL':     $laenge = 'Length(Bild)';
                            break;
          case 'SQLServer': $laenge = 'DataLength(Bild)';
                            break;
       }
       $sql = "Select Persnr, Name, Ort, Gebdatum, Gehalt, Vorgesetzt, $laenge AS Bildlaenge
               From Personal
               Where Upper(Name) Like Upper(:such)";

       $stmt = $conn->prepare($sql);            
       $stmt->bindParam(':such', $str, PDO::PARAM_STR);
       $str = "%$suche%";     
       $stmt->execute();
 
       // Ausgeben der gelesenen Daten:
       if (!($row = $stmt->fetch())) {
         echo "Ein Mitarbeiter mit dem gewünschten Teilstring im Namen existiert nicht!";
       } else {
?>
        <!-- Kopfzeile einer Tabelle definieren (mit <th> statt <td>: -->
        Ergebnis:
        <br>
        <table border cellpadding="10">
         <tr>
          <th>Persnr </th>
          <th>Name </th>
          <th>Ort </th>
          <th>GebDatum </th>
          <th>Gehalt </th>
          <th>Vorgesetzter? </th>
          <th>Bild</th>
         </tr>
<?php
         // In einer Schleife werden die Daten ausgelesen:
         do {
?>
         <tr>
         <!-- Die ausgelesenen Daten werden gleich in die Tabelle uebernommen: -->
          <td> <?php echo $row["PERSNR"]; ?> </td>
          <td> <?php echo $row["NAME"]; ?> </td>
          <td> <?php echo $row["ORT"]; ?> </td>
          <td> <?php echo $row["GEBDATUM"]; ?> </td>
          <td> <?php echo ($row["GEHALT"] == null)?"(null)":$row["GEHALT"]; ?> </td>
          <td>
           <?php echo ($row["VORGESETZT"] == null)? "Ja" : "Nein";?> </td>
   
         <!-- Ausgabe des Bildes mit Hilfe einer eigenen PHP-Seite bild.php, in der nur das Bild ausgegeben wird.
               Die Personalnr dient als Identifikator und wird als GET-Variable uebergeben: -->
<?php 
          if ($row["BILDLAENGE"] > 0)
          {		  
            echo "<td> <img src=\"bild.php?id=$row[PERSNR]\" height=150/> </td>";
          } else
            echo "<td> <br/>-- kein Bild --<br/> </td>";
?>  
         </tr>
<?php
         } while ($row = $stmt->fetch());

         echo "</table>";
       }  // endif fetch

       // Die Datenbank wird jetzt geschlossen:
       $conn->commit();
       $stmt = null; $conn = null;       // Beenden der Verbindung
     }  // endif try
   
      // PDO Fehlerbehandlung
     catch (PDOException $e)
     {
        echo "<p>Datenbankfehler in Zeile ", $e->getLine(), " mit Fehlercode ", $e->getCode(), " (", $e->errorInfo[1], ")</p>",
             "<p>Fehlertext: ", $e->getMessage(), "</p>";  
     }   
 
      // Globale Fehlerbehandlung
     catch (Exception $e)
     {
        echo "<p>Fehler in Zeile ", $e->getLine(), " mit Fehlercode ", $e->getCode(), "</p>",
             "<p>Fehlertext: ", $e->getMessage(), "</p>";  
     }   
    } 
  }     
}  // endif isset
?>

<p><center><a href="index.php">Zurück zur Auswahlseite der Session</a></center></p>
<p><center><a href="reset.php">Beenden der Session und neues Einloggen</a></center></p>
</body>
</html>