<?php
  session_start();
  include("lib.php");                                        // eigene PHP für Tabellenfunktion einschliessen
?>

<html>
<head>
<meta http-equiv="content-type" content="text/html" charset="utf-8">
<meta name="description" content="Datenbanken und SQL: Einfache GUI">
<meta name="author" content="Edwin Schicker">
<title>Datenbanken und SQL: Einfache GUI</title>
</head>

<body text="#000000" bgcolor="#FFFFEF" link="#FF0000" alink="#FF0000" vlink="#FF0000">
<center><h1>Datenbanken und SQL</h1></center>
<center><h3>Edwin Schicker</h3></center>
<p>Dies ist die Datei <i>select.php</i> im Sessionteil; die Datei ruft sich selbst wieder auf. </p>

<?php
if (!isset($_SESSION['Hersteller']) and !isset($_SESSION['Parameter1']) and
    !isset($_SESSION['Kennung']) and !isset($_SESSION['Passwort']) )
{
  echo "<p>Bitte starten Sie zuerst mit der Eingabe-Startseite. Sie werden automatisch nach 5 Sekunden weitergeleitet.</p>";
  // automatisches Zurueckspringen nach 5 Sekunden nach 'index.html': 
  echo '<meta http-equiv="Refresh" content="5;url=index.html">';
}
else
{
?>
  <p>Geben Sie einen SQL-Befehl ein.</p>
  <p>Achtung: Jeder Einzelbefehl wird <b>committed</b>!</p>
  <form action="select2.php" method="post">
    <table cellpadding=10>
       <tr>
        <td valign="top">SQL-Befehl<br>(ohne Semikolon!): </td>
        <td><textarea name="Eingabe" rows="10" cols="60" wrap="virtual"><?php
                     echo isset($_POST['Eingabe'])?trim(htmlspecialchars($_POST['Eingabe'])):"" ?>
            </textarea></td>
    </tr>
    <tr>
        <td></td><td><input type="Submit" value="Ausführen"/></td>
    </tr>
    </table>
  </form>

<?php
  if (isset($_POST['Eingabe'])) 
  try
  {
    // neues PDO-Objekt anlegen und mit angegebenen DB verbinden:
   $conn = new PDO($_SESSION['Parameter1'],$_SESSION['Kennung'],$_SESSION['Passwort']);

   echo "<hr noshade size=\"1\">";
   echo "<p>Die Verbindung zur Datenbank $_SESSION[Hersteller] wurde hergestellt.</p>";

   $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);   // ausfuehrliches Fehlerhandling
   $conn->setAttribute(PDO::ATTR_CASE, PDO::CASE_UPPER);             // immer Grossbuchstaben als Attributrueckgabe
   $conn->beginTransaction();                                        // Transaktionsmodus
    // Ueberpruefen, um welchen Befehl es sich handelt.
   $Eingabe = trim($_POST['Eingabe']);                               // Fuehrende Leerzeichen entfernen
   $stmt = $conn->query($Eingabe);                                   // Ausfuehren des SQL-Befehls

   $erstesWort = substr($Eingabe, 0, 6);      // Erstes Wort: Select, Delete, Update, Insert sind 6 Zeichen lang

   if (strCaseCmp($erstesWort,"SELECT")==0)
   {                                           // Select Befehl
     // Tabelle ausgeben:
     if (!tabelle($stmt))
       echo "<p>Keine Daten oder Fehler</p>";
   }
   elseif (strCaseCmp($erstesWort,"INSERT")==0)
   {
     echo "<p>", $stmt->rowCount(), " Zeile(n) wurde(n) eingefügt.</p>";
   }
   elseif (strCaseCmp($erstesWort,"UPDATE")==0)
   {
     echo "<p>", $stmt->rowCount(), " Zeile(n) wurde(n) ge&ändert.</p>";
   }
   elseif (strCaseCmp($erstesWort,"DELETE")==0)
   { 
     echo "<p>", $stmt->rowCount(), " Zeile(n) wurde(n) gelöscht.</p>";
   }
   else
   {
     echo "<p>Ein DDL-Befehl wurde ausgeführt.</p>";
   }

   $conn->commit();
   echo "<p>Transaktion erfolgreich abgeschlossen. Die Verbindung zur Datenbank wird geschlossen.</p>";
   $stmt = null; $conn = null;
  }  // end try
 
   // PDO Fehlerbehandlung
  catch (PDOException $e)
  {
     echo "<p>Datenbankfehler in Zeile ", $e->getLine(), " mit Fehlercode ", $e->getCode(), " (", $e->errorInfo[1], ")</p>",
          "<p>Fehlertext: ", $e->getMessage(), "</p>";  
  }   
 
   // Globale Fehlerbehandlung
  catch (Exception $e)
  {
     echo "<p>Fehler in Zeile ", $e->getLine(), " mit Fehlercode ", $e->getCode(), "</p>",
          "<p>Fehlertext: ", $e->getMessage(), "</p>";  
  }   
}  // endif  
?>
<hr noshade size="1">
<p><center><a href="index.php">Zurück zur Auswahlseite der Session</a></center></p>
<p><center><a href="reset.php">Beenden der Session und neues Einloggen</a></center></p>
</body>
</html>