<?php
  session_start();
?>

<html>
<head>
<meta http-equiv="content-type" content="text/html" charset="utf-8">
<meta name="description" content="Datenbanken und SQL: Erster Zugriff auf DB in Session">
<meta name="author" content="Edwin Schicker">
<title>Datenbanken und SQL: Erster Zugriff auf DB in Session</title>
</head>

<body text="#000000" bgcolor="#FFFFEF" link="#FF0000" alink="#FF0000" vlink="#FF0000">
<center><h1>Datenbanken und SQL</h1></center>
<center><h3>Edwin Schicker</h3></center>
<p>Dies ist die Datei <i>start.php</i> im Sessionteil. </p>

<?php
  if (!isset($_SESSION['Hersteller']) and !isset($_SESSION['Parameter1']) and
      !isset($_SESSION['Kennung']) and !isset($_SESSION['Passwort']) )
  {
    echo "<p>Bitte starten Sie zuerst mit der Eingabe-Startseite. Sie werden automatisch nach 5 Sekunden weitergeleitet.</p>";
    // automatisches Zurueckspringen nach 5 Sekunden nach 'index.html': 
    echo '<meta http-equiv="Refresh" content="5;url=index.html">';
  }
  else
  {
?>
    <p>Wir loggen uns jetzt in die Datenbank BIKE ein. Misslingt diese Verbindung, so wird in den
    Folgezeilen eine Fehlermeldung erscheinen. Ansonsten wird der Name des Mitarbeiters mit der
    Peronalnummer 2 ausgegeben, falls existent!</p>
<?php
    echo "<p>Aufbau einer Verbindung zur Datenbank '$_SESSION[Hersteller]'.</p>";

    try
    {
       // neues PDO-Objekt anlegen und mit angegebenen DB verbinden:
       $conn = new PDO($_SESSION['Parameter1'],$_SESSION['Kennung'],$_SESSION['Passwort']);

       echo "<p>Die Verbindung zur Datenbank $_SESSION[Hersteller] wurde hergestellt.</p>";

       $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);   // ausfuehrliches Fehlerhandling
       $conn->setAttribute(PDO::ATTR_CASE, PDO::CASE_UPPER);             // immer Grossbuchstaben als Attributrueckgabe
       $conn->beginTransaction();                                        // Transaktionsmodus

       // Die Datenbank ist geoeffnet, jetzt wird zugegriffen:
     
       $sql = "Select Name, Ort From Personal Where Persnr = 2";
       $stmt = $conn->query($sql);                          // Ausfuehren des Befehls und Ablage in $stmt

       if ($row = $stmt->fetch())                           // Auslesen der ersten Zeile des Ergebnisses
       {
          echo "Der Mitarbeiter mit der Personalnummer 2 heißt ",    // erfolgreich
               "$row[NAME] und wohnt in $row[ORT].<br>";
       } else
       {
          echo "<p>Der Mitarbeiter mit der angegebenen Nummer existiert nicht!</p>";
       }
       $conn->commit();  
       $stmt = null; $conn = null;          // beenden der Verbindung       
       echo "<p>Die Verbindung zur Datenbank wird geschlossen.</p>";
    }

    // PDO Fehlerbehandlung
    catch (PDOException $e)
    {
       echo "<p>Datenbankfehler in Zeile ", $e->getLine(), " mit Fehlercode ", $e->getCode(), " (", $e->errorInfo[1], ")</p>",
            "<p>Fehlertext: ", $e->getMessage(), "</p>";  
    }   
 
    // Globale Fehlerbehandlung
    catch (Exception $e)
    {
       echo "<p>Fehler in Zeile ", $e->getLine(), " mit Fehlercode ", $e->getCode(), "</p>",
            "<p>Fehlertext: ", $e->getMessage(), "</p>";  
    }   
  }
?>

<hr noshade size="1">

<p><center><a href="index.php">Zurück zur Auswahlseite der Session</a></center></p>
<p><center><a href="reset.php">Zurück zum Einloggen in die Datenbank</a></center></p>
</body>
</html>