<?php
  session_start();
?>
<html>
<head>
<meta http-equiv="content-type" content="text/html" charset="utf-8">
<meta name="description" content="Datenbanken und SQL: Transaktionsbetrieb 1">
<meta name="author" content="Edwin Schicker">
<title>Datenbanken und SQL: Transaktionsbetrieb 1</title>
</head>

<body text="#000000" bgcolor="#FFFFEF" link="#FF0000" alink="#FF0000" vlink="#FF0000">
<center><h1>Datenbanken und SQL</h1></center>
<center><h3>Edwin Schicker</h3></center>
<p>Dies ist die Datei <i>transaktion1.php</i> im Sessionteil, die die Datei <i>transaktion2.php</i> aufruft. </p>

<?php
if (!isset($_SESSION['Hersteller']) and !isset($_SESSION['Parameter1']) and
    !isset($_SESSION['Kennung']) and !isset($_SESSION['Passwort']) )
{
  echo "<p>Bitte starten Sie zuerst mit der Eingabe-Startseite. Sie werden automatisch nach 5 Sekunden weitergeleitet.</p>";
  // automatisches Zurueckspringen nach 5 Sekunden nach 'index.html': 
  echo '<meta http-equiv="Refresh" content="5;url=index.html">';
}
else
  try
  {
    echo "<p>Transaktionsbeispiel mit Provokation eines Deadlocks.</p>
           <p>Einloggen in die BIKE Datenbank:</p>";

     // neues PDO-Objekt anlegen und mit angegebenen DB verbinden:
    $conn = new PDO($_SESSION['Parameter1'],$_SESSION['Kennung'],$_SESSION['Passwort']);

    echo "<p>Die Verbindung zur Datenbank $_SESSION[Hersteller] wurde hergestellt.</p>";

    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);   // ausfuehrliches Fehlerhandling
    $conn->setAttribute(PDO::ATTR_CASE, PDO::CASE_UPPER);             // immer Grossbuchstaben als Attributrueckgabe
    $conn->beginTransaction();                                        // Transaktionsmodus

    // SQL-Befehl:
    $sql = " Select Nr, Name, Sperre
             From Kunde
             Order By Name";
    $stmt = $conn->query($sql);              // Ausfuehren des SQL-Befehls
?>
   
    <p>Im Folgenden werden alle Kunden mit den Sperrdaten ausgegeben. Geben Sie zwei Kunden an, wo die Sperrdaten um den Wert 1
    erhöht werden.</p>
    <p>Um Deadlocks zu provozieren, starten Sie die gleiche Anwendung ein zweites Mal in einem weiteren Browser innerhalb von
    10 Sekunden. Geben Sie dort die gleichen zwei Kunden an, aber in umgekehrter Reihenfolge!</p>

    <form action="transaktion2.php" method="post">
     <table border="2" cellpadding="2">
     <tr>
      <th>Kundnr</th>                 <!-- Spaltennamen -->
      <th>Name</th>
      <th>Sperre</th>
      <th>Kunde1</th>
      <th>Kunde2</th>
     </tr>
<?php
     while ( $row = $stmt->fetch() )
     {
       echo "<tr><td> $row[NR] </td>";    // Spalten ausgeben
       echo "<td> $row[NAME] </td>";
       echo "<td> $row[SPERRE] </td>";
       echo "<td><input type=\"Radio\" name=\"Kunde1\" value=\"$row[NR]\"/></td>";
       echo "<td><input type=\"Radio\" name=\"Kunde2\" value=\"$row[NR]\"/></td><tr>";
    }
?>
     </table>
     <p><input type="Submit" name="Button1" value="Angaben übernehmen"/></p>
     <p><input type="Reset" name="Button2" value="Rücksetzen"/></p>
    </form>
<?php
     // Die Transaktion wird jetzt beendet:
    $conn->commit();
    $stmt = null; $conn = null;       // Beenden der Verbindung
  }   //end try

   // PDO Fehlerbehandlung
  catch (PDOException $e)
  {
     echo "<p>Datenbankfehler in Zeile ", $e->getLine(), " mit Fehlercode ", $e->getCode(), " (", $e->errorInfo[1], ")</p>",
          "<p>Fehlertext: ", $e->getMessage(), "</p>";  
  }   
 
   // Globale Fehlerbehandlung
  catch (Exception $e)
  {
     echo "<p>Fehler in Zeile ", $e->getLine(), " mit Fehlercode ", $e->getCode(), "</p>",
          "<p>Fehlertext: ", $e->getMessage(), "</p>";  
  }   
?>
<hr noshade size="1">
<p><center><a href="index.php">Zurück zur Auswahlseite der Session</a></center></p>
<p><center><a href="reset.php">Beenden der Session und neues Einloggen</a></center></p>
</body>
</html>