<?php
   session_start();
   session_write_close();            // verhindert Synchronisation auf Browserebene
?>
<html>
<head>
<meta http-equiv="content-type" content="text/html" charset="utf-8">
<meta name="description" content="Datenbanken und SQL: Transaktionsbetrieb 2">
<meta name="author" content="Edwin Schicker">
<title>Datenbanken und SQL: Transaktionsbetrieb 2</title>
</head>

<body text="#000000" bgcolor="#FFFFEF" link="#FF0000" alink="#FF0000" vlink="#FF0000">
<center><h1>Datenbanken und SQL</h1></center>
<center><h3>Edwin Schicker</h3></center>
<p>Dies ist die Datei <i>transaktion2.php</i> im Sessionteil, der Update wird ausgeführt.</p>

<?php
if (!isset($_SESSION['Hersteller']) and !isset($_SESSION['Parameter1']) and
    !isset($_SESSION['Kennung']) and !isset($_SESSION['Passwort']) )
{
  echo "<p>Bitte starten Sie zuerst mit der Eingabe-Startseite. Sie werden automatisch nach 5 Sekunden weitergeleitet.</p>";
  // automatisches Zurueckspringen nach 5 Sekunden nach 'index.html': 
  echo '<meta http-equiv="Refresh" content="5;url=index.html">';
}
else
  try
  {
     echo" <p>Im folgenden wird das Sperrfeld des ersten Kunden um 1 erh&ouml;ht. Dann wird nach 10 Sekunden das Sperrfeld
            des zweiten Kunden erhöht. </p>";

       // neues PDO-Objekt anlegen und mit angegebenen DB verbinden:
     $conn = new PDO($_SESSION['Parameter1'],$_SESSION['Kennung'],$_SESSION['Passwort']);

     echo "<p>Die Verbindung zur Datenbank $_SESSION[Hersteller] wurde hergestellt.</p>";
     
     $versuch = 0;          // Noch keine Ausführung der Transaktion
     while ($versuch < 2)
     {
       $versuch++;          // Erster Versuch!
       // eigener weiter Try-Catch-Block, um die Transaktion wiederholen zu koennen!
       try
       {
         $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);   // ausfuehrliches Fehlerhandling
         $conn->setAttribute(PDO::ATTR_CASE, PDO::CASE_UPPER);             // immer Grossbuchstaben als Attributrueckgabe
         $conn->beginTransaction();                                        // Transaktionsmodus
 

         // Mit Update-Befehl das Sperrfeld des ersten Kunden erhoehen:
         $sql = "Update Kunde
                 Set Sperre = Sperre + 1
                 Where Nr = $_POST[Kunde1]";
         $stmt = $conn->query($sql);             // Ausfuehren des SQL-Befehls

         // Die geaenderten Werte ausgeben:
         $sql = "Select Nr, Name, Sperre
                 From Kunde
                 Order By Name";
         $stmt = $conn->query($sql);             // Ausfuehren des SQL-Befehls
?>
        <p>Die Änderungen des ersten Kunden sind ausgeführt. Die Zwischenwerte sind wie folgt</p>
        <table border="2" cellpadding="2">
        <tr>
         <th>Kundnr</th>                 <!-- Spaltennamen -->
         <th>Name</th>
         <th>Sperre</th>
        </tr>
<?php
         while ( $row = $stmt->fetch() )
         {
           echo "<tr><td> $row[NR] </td>";    // Spalten ausgeben
           echo "<td> $row[NAME] </td>";
           echo "<td> $row[SPERRE] </td></tr>";
         }
         echo "</table>";

         // Jetzt wird eine kurze Zwangspause eingelegt:

         echo "<p>Jetzt kommt eine kleine Pause von 10 Sekunden!</p>";
 
         @ob_flush();      // @ unterdrueckt eventuelle Warnings, wenn etwa kein Flush-Speicher vorhanden ist
         flush();         // zwingt zur Ausgabe auf Browser
         sleep(10);       // wartet 10 Sekunden

         // Mit Update-Befehl das Sperrfeld des zweiten Kunden erhöhen:
         $sql = "Update Kunde
                 Set Sperre = Sperre + 1
                 Where Nr = $_POST[Kunde2]";
         $stmt = $conn->query($sql);             // Ausfuehren des SQL-Befehls
 
         echo "<p>Der Update des zweiten Kunden wurde durchgeführt.</p>"; 

         // Die geaenderten Werte ausgeben:
         $sql = "Select Nr, Name, Sperre
                 From Kunde
                 Order By Name";
         $stmt = $conn->query($sql);             // Ausfuehren des SQL-Befehls
?>
        <p>Die neuen Werte sind wie folgt:</p>
        <table border="2" cellpadding="2">
        <tr>
         <th>Kundnr</th>                 <!-- Spaltennamen -->
         <th>Name</th>
         <th>Sperre</th>
        </tr>
<?php
         while ( $row = $stmt->fetch() )
         {
           echo "<tr><td> $row[NR] </td>";    // Spalten ausgeben
           echo "<td> $row[NAME] </td>";
           echo "<td> $row[SPERRE] </td></tr>";
         }
         echo "</table>";

         // Die Transaktion wird jetzt beendet:
         $conn->commit();
         $versuch = 2;                      // Wir sind fertig, ein Wiederholen kommt nicht in Betracht!
         $stmt = null; $conn = null;       // Beenden der Verbindung
       }   //end try

       // Lokale Fehlerbehandlung:  
       catch (PDOException $e)
       {
         $code = $e->getCode();
         if ($code == 'HY000')                          // Probleme mit Oracle!
           $code = $e->errorInfo[1];                    // herstellerspezifischer Code
         if ($versuch < 2 and ($code == 60 or $code == '40001'))   // 60: Deadlock in Oracle, '40001': Deadlock in SQLSTATE
         {
           echo "<p>Innerhalb der Datenbank traten Synchronisationsprobleme auf. Code: $code</p>";
           echo "<p>Nach 3 Sekunden wird die Transaktion nochmals ausgeführt.</p>";
           $conn->rollback();                                     // ganz wichtig!
           sleep(3);
         }
         else  	 
           throw $e;              // Fehler an uebergeordneten Fehlerblock weiterreichen
       }   // end catch
     }   // end while
   }   // end try

   // Allgemeine Fehlerbehandlung, faengt alle Fehler endgueltig ab:
   // PDO Fehlerbehandlung
  catch (PDOException $e)
  {
     echo "<p>Datenbankfehler in Zeile ", $e->getLine(), " mit Fehlercode ", $e->getCode(), " (", $e->errorInfo[1], ")</p>",
          "<p>Fehlertext: ", $e->getMessage(), "</p>";  
  }   
 
   // Globale Fehlerbehandlung
  catch (Exception $e)
  {
     echo "<p>Fehler in Zeile ", $e->getLine(), " mit Fehlercode ", $e->getCode(), "</p>",
          "<p>Fehlertext: ", $e->getMessage(), "</p>";  
  }   

?>
<hr noshade size="1">
<p><center><a href="index.php">Zurück zur Auswahlseite der Session</a></center></p>
<p><center><a href="reset.php">Beenden der Session und neues Einloggen</a></center></p>
</body>
</html>