<?php
  session_start();
?>

<html>
<head>
<meta http-equiv="content-type" content="text/html" charset="utf-8">
<meta name="description" content="Datenbanken und SQL: Übung 3, Kapitel 6">
<meta name="author" content="Edwin Schicker">
<title>Datenbanken und SQL: Übung 3 zu Kapitel 6</title>
</head>

<body text="#000000" bgcolor="#FFFFEF" link="#FF0000" alink="#FF0000" vlink="#FF0000">
<center><h1>Datenbanken und SQL</h1></center>
<center><h3>Edwin Schicker</h3></center>
<center><h4>Übungaufgabe 3 zu Kapitel 6</h4></center>

<p>Dies ist die Datei <i>ueb_kap6_3.php</i>. Diese Datei ruft die Datei <i>ueb_kap6_3b.php</i> auf.</p>

<p>Diese Übung liest Mitarbeiterdaten ein. Mit Klick auf den Speichern-Button werden diese Daten in die
Personaltabelle übernommen. Die Personalnummer wird automatisch vergeben.</p>
<p>Browser ermöglichen bei Datumsfeldern automatische eine komfortable Eingabe.</p>

<?php
if (!isset($_SESSION['Hersteller']) and !isset($_SESSION['Parameter1']) and
    !isset($_SESSION['Kennung']) and !isset($_SESSION['Passwort']) )
{
  echo "<p>Bitte starten Sie zuerst mit der Eingabe-Startseite. Sie werden automatisch nach 5 Sekunden weitergeleitet.</p>";
  // automatisches Zurueckspringen nach 5 Sekunden nach 'index.html': 
  echo '<meta http-equiv="Refresh" content="5;url=index.html">';
}
else
{
  try
  {
     // neues PDO-Objekt anlegen und mit angegebenen DB verbinden:
     $conn = new PDO($_SESSION['Parameter1'],$_SESSION['Kennung'],$_SESSION['Passwort']);

     echo "<p>Die Verbindung zur Datenbank $_SESSION[Hersteller] wurde hergestellt.</p>";

     $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);   // ausfuehrliches Fehlerhandling
     $conn->setAttribute(PDO::ATTR_CASE, PDO::CASE_UPPER);             // immer Grossbuchstaben als Attributrueckgabe
     $conn->beginTransaction();                                        // Transaktionsmodus

     // Die Datenbank ist geoeffnet, jetzt werden alle Mitarbeiter ausgelesen:
     
     $sql = "Select Persnr, Name From Personal";
     $stmt = $conn->query($sql);                          // Ausfuehren des Befehls und speichern der Ergebnisse in $stmt
     // Daten vorhanden?
     if ( !($row = $stmt->fetch()) )
        throw new PDOException ("Mitarbeiterdaten konnten nicht gelesen werden", 13);   //eigene Ausnahme werfen
     ;
?>     

<p>Eingabe der Daten eines neuen Mitarbeiters:</p>
<form action="ueb_kap6_3b.php" method="post">
<table cellspacing="10">
<tr>
 <td align="right"> Name: </td>
 <td valign="top"> <input type="Text" name="Name" size="25" maxlength="25"/> </td>
</tr>
<tr>
 <td align="right"> Geburtsdatum: </td>
 <td valign="top"> <input type="date" name="GebDatum" id="GebDatum">
</tr>
<tr>
 <td align="right"> Straße: </td>
 <td valign="top"> <input type="Text" name="Strasse" size="25" maxlength="25"/> </td>
</tr>
<tr>
 <td align="right"> PLZ: </td>
 <td valign="top"> <input type="Text" name="PLZ" size="5" maxlength="5"/> </td>
</tr>
<tr>
 <td align="right"> Wohnort: </td>
 <td valign="top"> <input type="Text" name="Ort" size="25" maxlength="25"/> </td>
</tr>
<tr>
 <td align="right"> Stand : </td>
 <td valign="top"> <input type="Radio" name="Stand" checked value="led"/>ledig<br/>
                  <input type="Radio" name="Stand" value="verh"/>verheiratet<br/>
                  <input type="Radio" name="Stand" value="gesch"/>geschieden<br/>
                  <input type="Radio" name="Stand" value="verwit"/>verwitwet  </td>
</tr>
<tr>
 <td align="right"> Vorgesetzter (Persnr oder leer): </td>
 <td valign="top"> 
     <!-- Select Box: -->
     <select name="Vorgesetzt" size="1">      <!-- size="1": Combo Box -->
      <option value="null" selected>(null)</option>    <!-- Vorgabe: null -->
<?php
     // In einer Schleife werden die Daten fuer die Select Box ausgelesen:
     do {
        echo "<option value=\"$row[PERSNR]\"> $row[NAME]</option>";
     } while ($row = $stmt->fetch());
?>
     </select>
  
 </td>
</tr>
<tr>
 <td align="right"> Aufgabe: <br><br><br></td>
 <td valign="top"> <input type="Text" name="Aufgabe" size="15" maxlength="15"/><br/><br/><br/> </td>
</tr>
<tr>
 <td></td>
 <td width=300> <input type="Submit" name="Button" value="In Datenbank speichern"/></td>
</tr>
<tr>
 <td></td>
 <td><input type="reset" value="Zurücksetzen"/></td>
</tr>
</table>
</form>

<?php
}
  // PDO Fehlerbehandlung
  catch (PDOException $e)
  {
     echo "<p>Datenbankfehler in Zeile ", $e->getLine(), " mit Fehlercode ", $e->getCode(), " (", $e->errorInfo[1], ")</p>",
          "<p>Fehlertext: ", $e->getMessage(), "</p>";  
  }   

  // Globale Fehlerbehandlung
  catch (Exception $e)
  {
     echo "<p>Fehler in Zeile ", $e->getLine(), " mit Fehlercode ", $e->getCode(), "</p>",
          "<p>Fehlertext: ", $e->getMessage(), "</p>";  
  }   
}
?>

<hr noshade size="1">

<p><center><a href="index.php">Zurück zur Auswahlseite der Session</a></center></p>
<p><center><a href="reset.php">Beenden der Session und neues Einloggen</a></center></p>
</body>
</html>
