<?php
  session_start();
?>

<html>
<head>
<meta http-equiv="content-type" content="text/html" charset="utf-8">
<meta name="description" content="Datenbanken und SQL: Übung 3, Kapitel 6">
<meta name="author" content="Edwin Schicker">
<title>Datenbanken und SQL: Übung 3 zu Kapitel 6</title>
</head>

<body text="#000000" bgcolor="#FFFFEF" link="#FF0000" alink="#FF0000" vlink="#FF0000">
<center><h1>Datenbanken und SQL</h1></center>
<center><h3>Edwin Schicker</h3></center>
<center><h4>Übungaufgabe 3 zu Kapitel 6</h4></center>

<p>Dies ist die Datei <i>ueb_kap6_3b.php</i>.</p>

<p>Diese Übung liest Mitarbeiterdaten ein. Mit Klick auf den Speichern-Button werden diese Daten in die
Personaltabelle übernommen. Die Personalnummer wird automatisch vergeben. Diese Datei übernimmt die
automatische Vergabe der Personalnummer und das Speichern der Daten.</p>

<?php
if (!isset($_SESSION['Hersteller']) and !isset($_SESSION['Parameter1']) and
    !isset($_SESSION['Kennung']) and !isset($_SESSION['Passwort']) )
{
  echo "<p>Bitte starten Sie zuerst mit der Eingabe-Startseite. Sie werden automatisch nach 5 Sekunden weitergeleitet.</p>";
  // automatisches Zurueckspringen nach 5 Sekunden nach 'index.html': 
  echo '<meta http-equiv="Refresh" content="5;url=index.html">';
}
else
{
  try
  {
     // neues PDO-Objekt anlegen und mit angegebenen DB verbinden:
     $conn = new PDO($_SESSION['Parameter1'],$_SESSION['Kennung'],$_SESSION['Passwort']);

     echo "<p>Die Verbindung zur Datenbank $_SESSION[Hersteller] wurde hergestellt.</p>";

     $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);   // ausfuehrliches Fehlerhandling
     $conn->setAttribute(PDO::ATTR_CASE, PDO::CASE_UPPER);             // immer Grossbuchstaben als Attributrueckgabe
     $conn->beginTransaction();                                        // Transaktionsmodus

     // Die Datenbank ist geoeffnet, jetzt wird die max. Persnr. ermittelt:
     $sql = "Select max(Persnr)+1 As 
             maxnr From Personal";
     $stmt = $conn->query($sql);              // SQL-Befehl ausfuehren

     if (!($row = $stmt->fetch()))
       // eigene Ausnahme werfen, wenn Lesen der Personalnummer misslingt:
       throw new Exception ("Fehler beim Rückliefern der Personalnummer. Die Daten konnten".
                            " nicht geschrieben werden.", 1);

     $persnr =  $row["MAXNR"] ;            // neue Personalnummer: MAX+1

     // Persnr, Name, GebDatum duerfen nicht NULL sein. Alle anderen Werte schon. Wir setzen diese gegebenenfalls auf NULL:
     // Wir setzen bei Strings gleich die Hochkommata!
     $Strasse    = (strlen(trim($_POST['Strasse']))==0)? 'null' : "'$_POST[Strasse]'";
     $PLZ        = (strlen(trim($_POST['PLZ']))==0)    ? 'null' :   $_POST['PLZ'];
     $Ort        = (strlen(trim($_POST['Ort']))==0)    ? 'null' : "'$_POST[Ort]'";
     $Vorgesetzt = ($_POST['Vorgesetzt']=='(null)')    ? 'null' :   $_POST['Vorgesetzt'];
     $Aufgabe    = (strlen(trim($_POST['Aufgabe']))==0)? 'null' : "'$_POST[Aufgabe]'";

     // Speichern des neuen Mitarbeiters:
     $sql = "Insert Into Personal (Persnr, Name, GebDatum, Strasse, PLZ, Ort,
                                   Stand, Vorgesetzt, Aufgabe)
             Values ($persnr, '$_POST[Name]', Date '$_POST[GebDatum]',
                     $Strasse, $PLZ, $Ort, '$_POST[Stand]', $Vorgesetzt, $Aufgabe ) ";

     $stmt = $conn->query($sql);             // Insert-Befehl ausfuehren

     $conn->commit();           
     echo "<p>Es wurde(n) ". $stmt->rowCount() . " Zeile(n) in die Datenbank eingefügt.</p>";
     echo "<p>Die Verbindung zur Datenbank wird geschlossen.</p>";
     $stmt = null; $conn = null;       // Beenden der DB-Verbindung
  }
  
  // PDO Fehlerbehandlung
  catch (PDOException $e)
  {
     echo "<p>Datenbankfehler in Zeile ", $e->getLine(), " mit Fehlercode ", $e->getCode(), " (", $e->errorInfo[1], ")</p>",
          "<p>Fehlertext: ", $e->getMessage(), "</p>";  
  }   

  // Globale Fehlerbehandlung
  catch (Exception $e)
  {
     echo "<p>Fehler in Zeile ", $e->getLine(), " mit Fehlercode ", $e->getCode(), "</p>",
          "<p>Fehlertext: ", $e->getMessage(), "</p>";  
  }   
}
?>

<hr noshade size="1">

<p><center><a href="index.php">Zurück zur Auswahlseite der Session</a></center></p>
<p><center><a href="reset.php">Beenden der Session und neues Einloggen</a></center></p>
</body>
</html>
