<?php
  session_start();
?>

<html>
<head>
<meta http-equiv="content-type" content="text/html" charset="utf-8">
<meta name="description" content="Datenbanken und SQL: &Uuml;bung 5, Kapitel 6">
<meta name="author" content="Edwin Schicker">
<title>Datenbanken und SQL: Übung 5 zu Kapitel 6</title>
</head>

<body text="#000000" bgcolor="#FFFFEF" link="#FF0000" alink="#FF0000" vlink="#FF0000">
<center><h1>Datenbanken und SQL</h1></center>
<center><h3>Edwin Schicker</h3></center>
<center><h4>Übungaufgabe 5 zu Kapitel 6</h4></center>

<p>Dies ist die Datei <i>ueb_kap6_5.php</i>. </p>

<p>Diese Übung liest alle Mitarbeiter in eine Combobox aus. Nach Auswahl eines Mitarbeiters und Klick auf
den Weiter-Button werden die Daten des Mitarbeiters ausgegeben. Existiert der Mitarbeiter nicht mehr, so 
erfolgt eine Mitteilung. </p>

<?php
if (!isset($_SESSION['Hersteller']) and !isset($_SESSION['Parameter1']) and
    !isset($_SESSION['Kennung']) and !isset($_SESSION['Passwort']) )
{
  echo "<p>Bitte starten Sie zuerst mit der Eingabe-Startseite. Sie werden automatisch nach 5 Sekunden weitergeleitet.</p>";
  // automatisches Zurueckspringen nach 5 Sekunden nach 'index.html': 
  echo '<meta http-equiv="Refresh" content="5;url=index.html">';
}
else
{
  try
  {
     // neues PDO-Objekt anlegen und mit angegebenen DB verbinden:
     $conn = new PDO($_SESSION['Parameter1'],$_SESSION['Kennung'],$_SESSION['Passwort']);

     echo "<p>Die Verbindung zur Datenbank $_SESSION[Hersteller] wurde hergestellt.</p>";

     $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);   // ausfuehrliches Fehlerhandling
     $conn->setAttribute(PDO::ATTR_CASE, PDO::CASE_UPPER);             // immer Grossbuchstaben als Attributrueckgabe
     $conn->beginTransaction();                                        // Transaktionsmodus

     // Die Datenbank ist geoeffnet, jetzt werden alle Mitarbeiter ausgelesen:
     
     $sql = "Select Persnr, Name From Personal";
     $stmt = $conn->query($sql);                          // Ausfuehren des Befehls und speichern der Ergebnisse in $stmt
     
     // Ausgeben der gelesenen Daten:
     if ( $row = $stmt->fetch() )
     {     // Das Einlesen war erfolgreich
?>
       <p>Bitte wählen Sie einen Mitarbeiter aus. Durch Klick auf den Weiter-Button werden die
       Daten dieses Mitarbeiters ausgegeben.</p>

       <form action="ueb_kap6_5.php" method="post">
       <table cellspacing=10>
       <tr>
         <td align="right">Bitte wählen Sie einen Mitarbeiter aus: </td>
         <td><!-- Select Box: -->
           <select name="Personalnr" size="1">      <!-- size="1": Combo Box -->
<?php
             // In einer Schleife werden die Daten fuer die Select Box ausgelesen:
             do {
               echo "<option value=\"$row[PERSNR]\"";
               if (isset($_POST['Personalnr']) and $_POST['Personalnr'] == $row['PERSNR'])
                  echo " selected";
               echo "> $row[NAME]</option>";
             } while ($row = $stmt->fetch());
?>
           </select>
         </td>
       </tr>
       <tr>
         <td></td>
         <td> <input type="Submit" value="Weiter"/> </td>
       </tr>
     </table>
     </form>
<?php
    } else          // eigene Ausnahme werfen:
        throw new PDOException ("Mitarbeiterdaten konnten nicht gelesen werden", 13);

    if ( isset($_POST['Personalnr']) ) 
    {
      echo "<hr noshade size=\"1\">";
      echo "<p>Die gewünschten Mitarbeiterdaten werden jetzt in der Datenbank gesucht.</p><p>";

      $sql = "Select Persnr, Name, Ort, Gehalt 
              From Personal
              Where Persnr = $_POST[Personalnr]" ;
     $stmt = $conn->query($sql);                   // Ausfuehren des Befehls und speichern der Ergebnisse in $stmt
     
     if ($row = $stmt->fetch())                           // Auslesen der ersten Zeile des Ergebnisses
     {                                // erfolgreich:
        echo "<p>Der Mitarbeiter mit der Personalnummer $_POST[Personalnr] heißt ",    
             "$row[NAME], wohnt in $row[ORT] und verdient $row[GEHALT] Euro.</p>";
     } else
     {
        echo "<p>Der Mitarbeiter mit der angegebenen Nummer $_POST[Mitarbeiter] existiert nicht!</p>";
     }
    }

    $conn->commit();           
    echo "<p>Die Verbindung zur Datenbank wird geschlossen.</p>";
    $stmt = null; $conn = null;       // Beenden der DB-Verbindung
  }
  
  // PDO Fehlerbehandlung
  catch (PDOException $e)
  {
     echo "<p>Datenbankfehler in Zeile ", $e->getLine(), " mit Fehlercode ", $e->getCode(), " (", $e->errorInfo[1], ")</p>",
          "<p>Fehlertext: ", $e->getMessage(), "</p>";  
  }   

  // Globale Fehlerbehandlung
  catch (Exception $e)
  {
     echo "<p>Fehler in Zeile ", $e->getLine(), " mit Fehlercode ", $e->getCode(), "</p>",
          "<p>Fehlertext: ", $e->getMessage(), "</p>";  
  }   
}
?>

<hr noshade size="1">

<p><center><a href="index.php">Zurück zur Auswahlseite der Session</a></center></p>
<p><center><a href="reset.php">Beenden der Session und neues Einloggen</a></center></p>
</body>
</html>
