<?php
  session_start();
?>

<html>
<head>
<meta http-equiv="content-type" content="text/html" charset="utf-8">
<meta name="description" content="Datenbanken und SQL: Übung 6, Kapitel 6">
<meta name="author" content="Edwin Schicker">
<title>Datenbanken und SQL: Übung 6 zu Kapitel 6</title>
</head>

<body text="#000000" bgcolor="#FFFFEF" link="#FF0000" alink="#FF0000" vlink="#FF0000">
<center><h1>Datenbanken und SQL</h1></center>
<center><h3>Edwin Schicker</h3></center>
<center><h4>Übungaufgabe 6 zu Kapitel 6</h4></center>

<p>Dies ist die Datei <i>ueb_kap6_6a.php</i>.</p>

<p>Diese Übung gibt die gewünschte Anzahl von Meistverdienenden aus. Für die Ausgabe wird der in einer früheren Übung behandelte komplexe Select-Befehl verwendet.</p>

<?php
if (!isset($_SESSION['Hersteller']) and !isset($_SESSION['Parameter1']) and
    !isset($_SESSION['Kennung']) and !isset($_SESSION['Passwort']) )
{
  echo "<p>Bitte starten Sie zuerst mit der Eingabe-Startseite. Sie werden automatisch nach 5 Sekunden weitergeleitet.</p>";
  // automatisches Zurueckspringen nach 5 Sekunden nach 'index.html': 
  echo '<meta http-equiv="Refresh" content="5;url=index.html">';
}
else
{
  try
  {
     $anzahl = $_POST['Anzahl'];
     if ($anzahl > 0 && $anzahl < 100)
     {
     
       // neues PDO-Objekt anlegen und mit angegebenen DB verbinden:
       $conn = new PDO($_SESSION['Parameter1'],$_SESSION['Kennung'],$_SESSION['Passwort']);

       echo "<p>Die Verbindung zur Datenbank $_SESSION[Hersteller] wurde hergestellt.</p>";
 
       $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);   // ausfuehrliches Fehlerhandling
       $conn->setAttribute(PDO::ATTR_CASE, PDO::CASE_UPPER);             // immer Grossbuchstaben als Attributrueckgabe
       $conn->beginTransaction();                                        // Transaktionsmodus

       // Die Datenbank ist geoeffnet. Jetzt wird der komplexe Select-Befehl ausgefuehrt:
       $sql = " Select Persnr, Name, Gehalt
                From Personal P
                Where Gehalt Is Not Null
                  And (Select Count(*)
                       From Personal
                       Where Gehalt > P.Gehalt) < $anzahl
                Order By Gehalt Desc ";
       $stmt = $conn->query($sql);                 // Select-Befehl ausfuehren

       echo "<p>Ausgabe der $anzahl Meistverdienenden in absteigender Reihenfolge:</p>";

       echo "<table border=\"2\" cellpadding=\"2\"><tr>";
       echo "<th>Persnr</th>";                 // Spaltennamen
       echo "<th>Name</th>";
       echo "<th>Gehalt</th></tr>";

       while ( $row = $stmt->fetch() )
       {
         echo "<tr><td> $row[PERSNR] </td>";    // Spalten ausgeben
         echo "<td> $row[NAME] </td>";
         echo "<td> $row[GEHALT] </td></tr>";
       }
       echo "</table>";

       $conn->commit();           
       echo "<p>Die Transaktion ist beendet. Die Verbindung zur Datenbank wird geschlossen.</p>";
       $stmt = null; $conn = null;       // Beenden der DB-Verbindung
     }
     else
     {
       echo"<p>Bitte geben Sie eine Zahl im Bereich 1 bis 99 ein.</p>";
     }
  }
  
  // PDO Fehlerbehandlung
  catch (PDOException $e)
  {
     echo "<p>Datenbankfehler in Zeile ", $e->getLine(), " mit Fehlercode ", $e->getCode(), " (", $e->errorInfo[1], ")</p>",
          "<p>Fehlertext: ", $e->getMessage(), "</p>";  
  }   

  // Globale Fehlerbehandlung
  catch (Exception $e)
  {
     echo "<p>Fehler in Zeile ", $e->getLine(), " mit Fehlercode ", $e->getCode(), "</p>",
          "<p>Fehlertext: ", $e->getMessage(), "</p>";  
  }   
}
?>

<hr noshade size="1">

<p><center><a href="index.php">Zurück zur Auswahlseite der Session</a></center></p>
<p><center><a href="reset.php">Beenden der Session und neues Einloggen</a></center></p>
</body>
</html>
