<?php
  session_start();
?>

<html>
<head>
<meta http-equiv="content-type" content="text/html" charset="utf-8">
<meta name="description" content="Datenbanken und SQL: Übung 7 Kapitel 6">
<meta name="author" content="Edwin Schicker">
<title>Datenbanken und SQL: Übung 7 Kapitel 6</title>
</head>

<body text="#000000" bgcolor="#FFFFEF" link="#FF0000" alink="#FF0000" vlink="#FF0000">
<center><h1>Datenbanken und SQL</h1></center>
<center><h3>Edwin Schicker</h3></center>
<center><h4>Übungaufgabe 7 zu Kapitel 6</h4></center>

<p>Dies ist die Datei <i>ueb_kap6_7.php</i> im Sessionteil, die sich selbst wieder aufruft. </p>

<?php
if (!isset($_SESSION['Hersteller']) and !isset($_SESSION['Parameter1']) and
    !isset($_SESSION['Kennung']) and !isset($_SESSION['Passwort']) )
{
  echo "<p>Bitte starten Sie zuerst mit der Eingabe-Startseite. Sie werden automatisch nach 5 Sekunden weitergeleitet.</p>";
  // automatisches Zurueckspringen nach 5 Sekunden nach 'index.html': 
  echo '<meta http-equiv="Refresh" content="5;url=index.html">';
}
else
{
  try
  {
     // neues PDO-Objekt anlegen und mit angegebenen DB verbinden:
     $conn = new PDO($_SESSION['Parameter1'],$_SESSION['Kennung'],$_SESSION['Passwort']);

     echo "<p>Die Verbindung zur Datenbank $_SESSION[Hersteller] wurde hergestellt.</p>";

     $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);   // ausfuehrliches Fehlerhandling
     $conn->setAttribute(PDO::ATTR_CASE, PDO::CASE_UPPER);             // immer Grossbuchstaben als Attributrueckgabe
     $conn->beginTransaction();                                        // Transaktionsmodus
     
     // Jetzt werden die Lieferantendaten gelesen:
     $sql = "Select Nr, Name                         
             From Lieferant" ;                           // Lieferantendaten
     $stmt = $conn->query($sql);                         // Ausfuehren des SQL-Befehls

     // Ausgeben der gelesenen Daten:
     if ($row = $stmt->fetch())
     {     // Das Einlesen von je mindestens einem Wert hat geklappt
?>
       <p>Bitte wählen Sie einen Lieferanten aus. Durch Klick auf den Weiter-Button werden alle Artikel angezeigt, 
       die dieser Lieferant liefert. Die Anzeige erfolgt je nach Einstellung des Radio-Buttons auf- bzw. absteigend.</p>

     <!-- Tabelle mit Select-Box: -->
       <form action="ueb_kap6_7.php" method="post">
       <table cellpadding=10>
       <tr>
         <td align="right">Bitte wählen Sie einen Lieferanten aus: </td>
         <td><!-- Select Box: -->
           <select name="Lieferantnr" size="1">      <!-- size="1": Drop Down Box -->
<?php
             // In einer Schleife werden die Daten fuer die Select Box ausgelesen:
             //  siehe auch erste Select-Box wegen Vorauswahl
             do {
               echo "<option value=\"$row[NR]\"";
               if (isset($_POST['Lieferantnr']) and $_POST['Lieferantnr'] == $row['NR'])
                  echo " selected";
               echo "> $row[NAME]</option>";
             } while ($row = $stmt->fetch());
?>
           </select>
         </td>
       </tr>
       <tr>
        <td> Bitte geben Sie noch die Anzeigereihenfolge an: </td>
        <td>
         <input type="radio" name="Reihenfolge" value="asc" checked/> aufsteigend &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;  
         <input type="radio" name="Reihenfolge" value="desc"/> absteigend sortiert</td>
       </tr>
       <tr>
         <td></td>
         <td> <input type="Submit" value="Weiter"/> </td>
       </tr>
     </table>
     </form>
<?php
    } else          // eigene Ausnahme werfen:
         throw new PDOException ("Kunden-/Artikeldaten konnten nicht gelesen werden", 13);

    if (isset($_POST['Lieferantnr']))
    {
      echo "<hr noshade size=\"1\">";
      echo "<p>Die dazugeh&ouml;rigen Artikel werden jetzt in der Datenbank gesucht.</p><p>";

      // Lesen der Post-Variable:
      $lieferantnr  = $_POST['Lieferantnr'];

       // Die Datenbank ist geoeffnet, jetzt werden die Artikeldaten gelesen, die der ausgewaehlte Lieferant liefert:
      $sql2 = "Select Artikel.Anr, Bezeichnung, Mass, Einheit
               From   Artikel Inner Join Lieferung On Artikel.Anr=Lieferung.Anr
               Where  Liefnr = $lieferantnr 
               order by Artikel.Anr $_POST[Reihenfolge] ";          // mit Sortierreihenfolge 
      $stmt2 = $conn->query($sql2);                                 // Ausfuehren des SQL-Befehls

       // Ausgeben der gelesenen Daten:
      if (!($row2 = $stmt2->fetch()))
      {        // Keine Daten
         echo "<p>Zum markierten Lieferanten $lieferantnr liegen keine Artikeldaten vor.</p>";
      }
      else
      {
?>
        <p>Bitte geben Sie zu jedem Artikel die Anzahl der neuen Lieferung an:</p>
     <form action="ueb_kap6_7b.php" method="post">
        <!-- Kopfzeile einer Tabelle definieren (mit <th> statt <td>: -->
        <p>
        <table border cellpadding=10>
         <tr>
          <th>Artikelnr </th>
          <th>Artikel </th>
          <th>Maß </th>
          <th>Einheit </th>
          <th>Anzahl </th>
         </tr>
<?php
         // In einer Schleife werden die Daten ausgelesen:
         do
         {
            echo "<tr>";
            // Die ausgelesenen Daten werden gleich in die Tabelle uebernommen:
            echo "<td> $row2[ANR] </td>
                  <td> $row2[BEZEICHNUNG]</td>
                  <td> $row2[MASS]</td>
                  <td> $row2[EINHEIT]</td>
                  <td> <input type=\"text\" size=\"5\" name=\"Anzahl[$row2[ANR]]\" value=\"0\"/>",     // um sich zur Anzahl auch die Artikelnr zu merken!
                                                      // hier wird zu jedem Array-Wert auch der Key gespeichert. Key=Artikelnr, Content=Anzahl !
                  "</tr>";
          } while ($row2 = $stmt2->fetch());
?>
         </table>
         <p><input type="submit" value="Werte übernehmen"/></p>
         <p>Mit dem Klick auf den Button werden die Lagerdaten dieser Artikel aktualisiert.</p>	 
<?php
      }

      // Die Datenbank wird jetzt geschlossen:
      $conn->commit();
      echo "<p>Die Verbindung zur Datenbank wird geschlossen.</p>";
      $stmt = null; $stmt2 = null; $conn = null;       // Beenden der DB-Verbindung
   }
  }
   // PDO Fehlerbehandlung
  catch (PDOException $e)
  {
     echo "<p>Datenbankfehler in Zeile ", $e->getLine(), " mit Fehlercode ", $e->getCode(), " (", $e->errorInfo[1], ")</p>",
          "<p>Fehlertext: ", $e->getMessage(), "</p>";  
  }   
 
   // Globale Fehlerbehandlung
  catch (Exception $e)
  {
     echo "<p>Fehler in Zeile ", $e->getLine(), " mit Fehlercode ", $e->getCode(), "</p>",
          "<p>Fehlertext: ", $e->getMessage(), "</p>";  
  }   
}
?>
<hr noshade size="1">
<p><center><a href="index.php">Zurück zur Auswahlseite der Session</a></center></p>
<p><center><a href="reset.php">Beenden der Session und neues Einloggen</a></center></p>
</body>
</html>