<?php
   session_start();
   session_write_close();            // verhindert Synchronisation auf Browserebene
?>
<html>
<head>
<meta http-equiv="content-type" content="text/html" charset="utf-8">
<meta name="description" content="Datenbanken und SQL: Übung 7 Kapitel 6">
<meta name="author" content="Edwin Schicker">
<title>Datenbanken und SQL: Übung 7 Kapitel 6</title>
</head>

<body text="#000000" bgcolor="#FFFFEF" link="#FF0000" alink="#FF0000" vlink="#FF0000">
<center><h1>Datenbanken und SQL</h1></center>
<center><h3>Edwin Schicker</h3></center>
<center><h4>Übungaufgabe 7 zu Kapitel 6</h4></center>

<p>Dies ist die Datei <i>ueb_kap6_7b.php</i> im Sessionteil, der Update wird ausgefÜhrt.</p>

<?php
if (!isset($_SESSION['Hersteller']) and !isset($_SESSION['Parameter1']) and
    !isset($_SESSION['Kennung']) and !isset($_SESSION['Passwort']) )
{
  echo "<p>Bitte starten Sie zuerst mit der Eingabe-Startseite. Sie werden automatisch nach 5 Sekunden weitergeleitet.</p>";
  // automatisches Zurueckspringen nach 5 Sekunden nach 'index.html': 
  echo '<meta http-equiv="Refresh" content="5;url=index.html">';
}
else
  try
  {
     echo" <p>Im folgenden werden die Artikel mit der angegebenen Anzahl im Lager hinzugef&uuml;gt.
           Dazwischen wird jeweils 3 Sekunden gewartet.</p>";
     
       // neues PDO-Objekt anlegen und mit angegebenen DB verbinden:
     $conn = new PDO($_SESSION['Parameter1'],$_SESSION['Kennung'],$_SESSION['Passwort']);

     echo "<p>Die Verbindung zur Datenbank $_SESSION[Hersteller] wurde hergestellt.</p>";
     
     $versuch = 0;          // Noch keine Ausfuehrung der Transaktion
     while ($versuch < 3)   // maximal 3 Versuche
     {
       $versuch++;          // Erster Versuch!
       // eigener weiter Try-Catch-Block, um die Transaktion wiederholen zu koennen!
       try
       {
         $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);   // ausfuehrliches Fehlerhandling
         $conn->setAttribute(PDO::ATTR_CASE, PDO::CASE_UPPER);             // immer Grossbuchstaben als Attributrueckgabe
         $conn->beginTransaction();                                        // Transaktionsmodus
 
         // In einer Schleife wird das Lager aufgefuellt:
         foreach ($_POST['Anzahl'] as $artnr=>$anzahl)
         {
            $sql = "Update Lager
                    Set Bestand = Bestand + $anzahl
                    Where Artnr = $artnr";
            $stmt = $conn->query($sql);             // Ausfuehren des SQL-Befehls
    
            echo "Update $artnr. Bitte kurz warten</br>";
            ob_flush();
            flush();         // zwingt zur Ausgabe auf Browser
            sleep(3);        // wartet 3 Sekunden
         } 
         
         echo "<p>Die Daten wurden in das Lager übernommen.</p>";

         // Die Transaktion wird jetzt beendet:
         $conn->commit();
         $versuch = 3;                // Wir sind fertig, ein Wiederholen kommt nicht in Betracht!
         $stmt = null; $conn = null;       // Explizites Beenden der DB-Verbindung, hier nicht erforderlich
       }   //end try

       // Lokale Fehlerbehandlung:  
       catch (PDOException $e)
       {
         $code = $e->getCode();
         if ($code == "HY000")                          // Probleme mit Oracle!
           $code = $e->errorInfo[1];                    // herstellerspezifischer Code
         if ($versuch < 3 and ($code == 60 or $code == '40001'))           // 60: Deadlock in Oracle, '40001': Deadlock in SQLSTATE
         {
           echo "<p>Innerhalb der Datenbank traten Synchronisationsprobleme auf. Code: $code</p>";
           echo "<p>Nach 3 Sekunde wird die Transaktion nochmals ausgef&uuml;hrt.</p>";
           $conn->rollback();                                     // ganz wichtig!
           sleep(3);
         }
         else   
           throw $e;              // Fehler an uebergeordneten Fehlerblock weiterreichen
       }   // end catch
     }   // end while
   }   // end try

   // Allgemeine Fehlerbehandlung, faengt alle Fehler endgueltig ab:
   // PDO Fehlerbehandlung
  catch (PDOException $e)
  {
     echo "<p>Datenbankfehler in Zeile ", $e->getLine(), " mit Fehlercode ", $e->getCode(), " (", $e->errorInfo[1], ")</p>",
          "<p>Fehlertext: ", $e->getMessage(), "</p>";  
  }   
 
   // Globale Fehlerbehandlung
  catch (Exception $e)
  {
     echo "<p>Fehler in Zeile ", $e->getLine(), " mit Fehlercode ", $e->getCode(), "</p>",
          "<p>Fehlertext: ", $e->getMessage(), "</p>";  
  }   

?>
<hr noshade size="1">
<p><center><a href="index.php">Zurück zur Auswahlseite der Session</a></center></p>
<p><center><a href="reset.php">Beenden der Session und neues Einloggen</a></center></p>
</body>
</html>